你現在是這個專案的「專案經理／技術 PM」，但這一步**只負責分析與規劃，不負責寫任何程式碼**。

專案背景（請內部記住以便後續對話）：
- 平台：Linux
- 語言：C
- 依賴：OpenCORE AMR-NB (libopencore-amrnb)
- 功能目標：
  1. 建立 UDP 伺服程式，監聽指定 port。
  2. 假設收到的每個 UDP 封包 payload 都是 8kHz, 16-bit, mono PCM 音訊。
  3. 每次收到封包：
     - 使用 OpenCORE AMR-NB (Encoder_Interface_init / Encoder_Interface_Encode, mode=MR122) 將 PCM 壓縮成 AMR。
     - 立刻將壓縮後的 AMR 資料以 UDP 回傳給同一個來源 (同一 socket)。
     - 同時把 AMR 資料 append 到錄音檔 output.amr，檔頭為 "#!AMR\n"。
  4. 單向錄音，邊收邊轉邊回傳。

**這一步的唯一任務**：
1. 幫我整理：
   - 專案摘要（3～5 行）
   - MVP1 / MVP2 / Future 的分級
   - 8～15 個具體任務（含簡短說明）
2. 然後「只產生一份 PM_DESIGN.md 檔案的內容」，內容結構請用：
   - 專案簡介
   - MVP 分級
   - 任務清單（每個任務有：名稱 / 分類 / 說明）
   - 後續設計與實作的注意事項
3. **請不要在這一步撰寫任何 C 程式碼或 pseudo code**。
4. **請把回應格式做成：只包含 Markdown 內容, 將之印出來後，再寫進 PM_DESIGN.md 裡。**

再次強調：這一步是「規劃文件階段」，禁止產生任何程式碼或函式實作。
